/*
 * Decompiled with CFR 0.152.
 */
package com.mcwlights.kikoz.objects;

import com.mcwlights.kikoz.objects.LightBaseShort;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;

public class LightBaseTall
extends LightBaseShort
implements SimpleWaterloggedBlock {
    public static final EnumProperty<LightPart> PART = EnumProperty.m_61587_((String)"part", LightPart.class);

    public LightBaseTall(BlockBehaviour.Properties properties) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60978_(0.5f).m_155956_(5.0f).m_60953_(LightBaseTall.setLightLevel(15)));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)LightPart.BASE)));
    }

    private static ToIntFunction<BlockState> setLightLevel(int lightValue) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightValue : 0;
    }

    protected BlockState LightState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean below;
        boolean above = level.m_8055_(pos.m_7494_()).m_60734_() == this;
        boolean bl = below = level.m_8055_(pos.m_7495_()).m_60734_() == this;
        if (above && below) {
            return (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)LightPart.MIDDLE))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        if (!above && below) {
            return (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)LightPart.TOP))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
        }
        if (above && !below) {
            return (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)LightPart.BOTTOM))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)LightPart.BASE))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.m_60713_(state.m_60734_())) {
            this.LightState(state, (LevelAccessor)level, pos);
        }
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.LightState(super.m_5573_(context), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public void placeAt(Level level, BlockPos pos, int num) {
        level.m_7731_(pos, this.m_49966_(), num);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.LightState(state, level, pos);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        LightPart part = (LightPart)((Object)state.m_61143_(PART));
        ItemStack itemstack = player.m_21120_(handIn);
        Item item = itemstack.m_41720_();
        if (item != this.m_5456_()) {
            if (worldIn.m_5776_() && part == LightPart.BOTTOM || part == LightPart.MIDDLE) {
                return InteractionResult.PASS;
            }
            if (part == LightPart.TOP || part == LightPart.BASE) {
                state = (BlockState)state.m_61122_((Property)LIT);
                worldIn.m_7731_(pos, state, 10);
                worldIn.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.5f, worldIn.f_46441_.nextFloat() * 0.1f + 0.8f);
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, WATERLOGGED, LIT});
    }

    public static enum LightPart implements StringRepresentable
    {
        BASE("base"),
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private LightPart(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

